<?php
/*
Plugin Name: Open Graph
Plugin URI: 
Description: Enables the creation of Open Graph tags to help Facebook show correct info when URL's to your site are shared
Version: 1.1.0
Author: Daniel Liljeberg
Author URI: 
Short Name: opengraph
Plugin update URI: open-graph
*/


function opengraph_header() {
	?>
		<meta property="og:site_name" content="<?php echo osc_esc_html(osc_page_title());?>" />
	<?php if(osc_is_ad_page()):?>
	<?php
		$itemNoImage 	= osc_get_preference('itemNoImage', 'plugin-opengraph');
		
		$itemResource = Item::newInstance()->findResourcesByID(osc_item_id());		
		$numResources = count($itemResource);
		
		if($numResources > 0) {
			// Make sure we grab the primary image. They are indexed in reverse order.
			$itemResource = $itemResource[$numResources - 1];
		}
		else {
			$itemResource = null;
		}
		
		if(osc_plugin_is_enabled('listingtype/index.php')) {
			$prefix = ItemListingType::newInstance()->getFeedTitlePrefix(osc_item_id()) . ': ';			
			$title = $prefix . meta_title();
			$description = $prefix . meta_description(); 
		}
		else {
			$title = meta_title();
			$description = meta_description();
		}
	?>		
		<meta property="og:title" content="<?php echo osc_esc_html($title);?>" />
		<meta property="og:description" content="<?php echo osc_esc_html($description); ?>" />
		<meta property="og:type" content="product" />
		<meta property="og:url" content="<?php echo osc_item_url();?>" />
		<?php if($itemResource):?>
		<meta property="og:image" content="<?php echo osc_apply_filter('resource_path', osc_base_url().$itemResource['s_path']).$itemResource['pk_i_id'].".".$itemResource['s_extension']?>" />
		<?php else:?>
			<?php 
			if($itemNoImage == 1) {
				echo '<meta property="og:image" content="' . osc_plugin_url(__FILE__) . 'images/no_photo.png" />';
			} 
			else if($itemNoImage == 2) {
				$info = WebThemes::newInstance()->loadThemeInfo(WebThemes::newInstance()->getCurrentTheme());
				
				if( file_exists(WebThemes::newInstance()->getCurrentThemePath() . 'images/facebook_share_cover.png') ){
					echo '<meta property="og:image" content="' . osc_current_web_theme_url('images/facebook_share_cover.png');'" />';
				}
			}
			?>
		<?php endif;?>
		<meta property="product:original_price:amount"   content="<?php echo osc_esc_html(osc_item_price()/1000000)?>" /> 
		<meta property="product:original_price:currency" content="<?php echo osc_esc_html(osc_item_currency())?>" />
		<meta property="product:category" content="<?php echo osc_esc_html(osc_item_category())?>" />
		<meta property="product:is_product_shareable" content="true" /> 
	<?php elseif(osc_is_search_page()):?>
	<?php elseif(osc_is_home_page()):?>
		<?php
			$homepageImage 	= osc_get_preference('homepageImage', 'plugin-opengraph');
			$info = WebThemes::newInstance()->loadThemeInfo(WebThemes::newInstance()->getCurrentTheme());
		
			if( $homepageImage == 1 && file_exists(WebThemes::newInstance()->getCurrentThemePath() . 'images/facebook_share_cover.png') ){
			?>
			<meta property="og:image" content="<?php echo osc_current_web_theme_url('images/facebook_share_cover.png');?>" />
			<?php 
			} 
		?>
	<?php elseif(osc_is_user_dashboard()):?>
		<meta property="og:title" content="<?php echo osc_esc_html(meta_title()); ?>" />
		<meta property="og:description" content="<?php echo osc_esc_html(meta_description()); ?>" />
	<?php elseif(osc_is_static_page()):?>
		<meta property="og:title" content="<?php echo osc_esc_html(meta_title()); ?>" />
		<meta property="og:description" content="<?php echo osc_esc_html(meta_description()); ?>" />
	<?php elseif(osc_is_publish_page()):?>
		<meta property="og:title" content="<?php echo osc_esc_html(meta_title()); ?>" />
		<meta property="og:description" content="<?php echo osc_esc_html(meta_description()); ?>" />
	<?php endif;?>
		<meta property="og:locale" content="<?php echo osc_esc_html(osc_current_user_locale()); ?>" />
	<?php 
}

function opengraph_footer() {
	$forceUpdate	= osc_get_preference('forceUpdate', 'plugin-opengraph');
	if($forceUpdate == 1) {
		$pageURL = (@$_SERVER["HTTPS"] == "on") ? "https://" : "http://";
		if ($_SERVER["SERVER_PORT"] != "80")
		{
			$pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
		}
		else
		{
			$pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
		}
		?>
		<script>
			$.post(
				'https://graph.facebook.com',
				{
					id: '<?php echo $pageURL?>',
					scrape: true
				}
			);
		</script>
		<?php 
	}
}

function opengraph_admin_configuration() {
	// Standard configuration page for plugin which extend item's attributes
	osc_admin_render_plugin(osc_plugin_path(dirname(__FILE__)) . '/admin.php') ;
}

osc_register_plugin(osc_plugin_path(__FILE__), 'opengraph_install');
osc_add_hook(osc_plugin_path(__FILE__)."_uninstall", 'opengraph_uninstall');
osc_add_hook(osc_plugin_path(__FILE__)."_configure", 'opengraph_admin_configuration');

osc_add_hook('header', 'opengraph_header');
osc_add_hook('footer', 'opengraph_footer');