<?php
	if(!osc_logged_admin_id()) {
		die();
	}	   
        	
   	if( Params::getParam('option') == 'opengraph-settings' ) {
   		$homepageImage = Params::getParam('homepageImage');
   		$itemNoImage 	= Params::getParam('itemNoImage');
   		$forceUpdate 	= Params::getParam('forceUpdate');
   		osc_set_preference('homepageImage', $homepageImage, 'plugin-opengraph', 'INTEGER');
   		osc_set_preference('itemNoImage', $itemNoImage, 'plugin-opengraph', 'INTEGER');
   		osc_set_preference('forceUpdate', $forceUpdate, 'plugin-opengraph', 'INTEGER');
        echo '<div style="text-align:center; font-size:22px; background-color:#00bb00;"><p>' . __('Settings Saved', 'opengraph') . '.</p></div>';
    }
    else {
		$homepageImage 	= osc_get_preference('homepageImage', 'plugin-opengraph');
		$itemNoImage 	= osc_get_preference('itemNoImage', 'plugin-opengraph');
		$forceUpdate	= osc_get_preference('forceUpdate', 'plugin-opengraph');
    }
		
    $pluginInfo = osc_plugin_get_info('opengraph/index.php');   
?>

<form action="<?php osc_admin_base_url(true); ?>" method="post">
    <input type="hidden" name="page" value="plugins" />
    <input type="hidden" name="action" value="renderplugin" />
    <input type="hidden" name="file" value="opengraph/admin.php" />
    <input type="hidden" name="option" value="opengraph-settings" />
    <div>
    <fieldset>             
        <h2><?php _e('Open Graph Settings', 'opengraph'); ?></h2> 
        <fieldset>
        <label for="homepageImage" style="font-weight: bold;"><?php _e('Home page Image:', 'opengraph'); ?></label>:<br />
        <select name="homepageImage" id="homepageImage"> 
        	<option <?php if($homepageImage == 1){echo 'selected="selected"';}?>value='1'>facebook_share_cover.png</option>
        	<option <?php if($homepageImage == 0){echo 'selected="selected"';}?>value='0'><?php _e('Let Facebook pick one','opengraph'); ?></option>
        </select>        
        <br />
        <br />
        
        <label for="itemNoImage" style="font-weight: bold;"><?php _e('If item has no image:', 'opengraph'); ?></label>:<br />
        <select name="itemNoImage" id="itemNoImage"> 
        	<option <?php if($itemNoImage == 1){echo 'selected="selected"';}?>value='1'><?php _e('Display no_image.png','opengraph'); ?></option>
			<option <?php if($itemNoImage == 2){echo 'selected="selected"';}?>value='2'>facebook_share_cover.png</option>
        	<option <?php if($itemNoImage == 0){echo 'selected="selected"';}?>value='0'><?php _e('Let Facebook decide which image to grab','opengraph'); ?></option>
        </select>
        <br />
        <br />
        
        <label for="forceUpdate" style="font-weight: bold;"><?php _e('Force Facebook to scrape your pages:', 'opengraph'); ?></label>:<br />
        <select name="forceUpdate" id="forceUpdate"> 
        	<option <?php if($forceUpdate == 1){echo 'selected="selected"';}?>value='1'><?php _e('Yes','opengraph'); ?></option>
			<option <?php if($forceUpdate == 0){echo 'selected="selected"';}?>value='0'><?php _e('No','opengraph'); ?></option>
        </select>
        <br />
        <br />
        <div id="homepageImageInfo" style="display: none">
        	<h2>facebook_share_cover.png</h2>
			<p>
				<?php _e("In order to represent your entire site if you home page is shared you should browse to your current themes <i>images</i> folder and save an image in there named <b>facebook_share_cover.png</b>.", "opengraph");?>
				<br/>
				<?php echo sprintf(__("In your case this would be: <b>%s</b>", "opengraph"), osc_base_path() . 'oc-content/themes/' .  osc_current_web_theme() . '/images');?>
			</p>
			<p>
				<?php _e("This image should be at least 200x200 pixels. A good size is 534x200 since that seems to be the maximum shown in the share dialog.", "opengraph");?>
			</p>
			<p>
				<?php _e("If this image is not present, the default behaviour is used which means that Facebook will try to guess an image to include in the shared post.", "opengraph");?>
			</p>
		</div>
		<div id="itemNoImageInfo" style="display: none">
        	<h2><?php _e("No Item Image", "opengraph");?></h2>
			<p>
				<?php _e("In the plugins folder there is a folder named <b>images</b>. In that folder there is an image named <b>no_photo.png</b>. This image will be served to ads that don't have any images.", "opengraph");?>
				<br/>
				<?php _e("Feel free to replace this image if you would like another look.", "opengraph");?>
			</p>
			<p>
				<?php _e("If this image is not present, the default behaviour is used which means that Facebook will try to guess an image to include in the shared post.", "opengraph");?>
			</p>
		</div>
		<div id="forceUpdateInfo" style="display: none">
        	<h2><?php _e("Force Facebook to scrape your pages", "opengraph");?></h2>
			<p>
				<?php _e("This option will place a small ajax request to be sent to Facebook on each page load asking it to re-scrape the url in question.", "opengraph");?>
				<br/>
				<?php _e("This should <b>not</b> be turned on all the time. I don't know for sure, but I guess Facebook would not be happy with it enabled all the time for a site. Leaving it on would have some advantages though. An item where the advertiser would update pictures would start serving the new images etc.", "opengraph");?> 
			</p>
			<p>
				<?php _e("Instead, use this option if you quickly want to ask Facebook to re-scrape some pages. Enable this option, visit the URL's in question and disable it again.", "opengraph");?>
			</p>
		</div>
  
        <br />
        <input type="submit" value="<?php _e('Save', 'opengraph'); ?>" />        
        </fieldset>
        <?php echo '<br />' . __('Version ', 'opengraph') .  $pluginInfo['version'] . ' | ' .  __('Author','opengraph') . ' <a class="external" target="_blank" href="' . $pluginInfo['author_uri'] . '">' . $pluginInfo['author'] . '</a>'; ?>        
     </fieldset>
    </div>
</form>

<script>
	
	$( document ).ready(function() {
		$('#homepageImage').change(function() {
			if($(this).val() == 1) {
				$('#homepageImageInfo').show();
			}
			else {
				if($('#itemNoImage').val() != 2) {
					$('#homepageImageInfo').hide();
				}
			}
		});

		$('#itemNoImage').change(function() {
			if($(this).val() == 1) {
				$('#itemNoImageInfo').show();
			}
			else {			
				$('#itemNoImageInfo').hide();
			}

			if($(this).val() != 2 && $('#homepageImage').val() != 1) {
				$('#homepageImageInfo').hide();
			}
			else if($(this).val() == 2) {
				$('#homepageImageInfo').show();
			}
		});

		$('#forceUpdate').change(function() {
			if($(this).val() == 1) {
				$('#forceUpdateInfo').show();
			}
			else {
				$('#forceUpdateInfo').hide();
			}
		});

		$('#forceUpdate').change();
		$('#homepageImage').change();
		$('#itemNoImage').change();		
	});
</script>
