<?php
/*
Plugin Name: Automatic modal advertising to osclass
Plugin URI: https://osclass.pro
Description: This plugin advertise content with an modal window.
Version: 1.0.1
Author: fog and osclass.pro
Author URI: http://cmd.com.pt
Short Name: AMA
Plugin update URI: automatic-modal-advertising
*/
define('AMA_PATH', dirname(__FILE__) . '/');
if (!function_exists('automatic_modal_advertising_call_after_install')) {
    function automatic_modal_advertising_call_after_install() {
        osc_set_preference('automatic_modal_advertising_version', '200', 'automatic_modal_advertising', 'STRING');
        osc_set_preference('ama-alert-form-box', '1', 'automatic_modal_advertising');
        osc_set_preference('ama-banner-image-box', '1', 'automatic_modal_advertising');
        osc_set_preference('ama-embedded-box', '', 'automatic_modal_advertising');
        osc_set_preference('ama-embedded-code', 'automatic_modal_advertising');
        osc_set_preference('ama-custom-css', 'no', 'automatic_modal_advertising');
        osc_set_preference('ama-ipage-alert-form', '2', 'automatic_modal_advertising');
        osc_set_preference('ama-clickit-alert-form', '5', 'automatic_modal_advertising');
        osc_set_preference('ama-banner-img', 'http://advertisehere.com/img/advertise-here.jpg', 'automatic_modal_advertising');
        osc_set_preference('ama-href-banner-img', 'automatic_modal_advertising');
        osc_set_preference('ama-image-banner-blank', 'yes', 'automatic_modal_advertising');
        osc_set_preference('ama-clickit-banner-image', '1', 'automatic_modal_advertising');
        osc_set_preference('ama-clickit-embedded', '0', 'automatic_modal_advertising');
        osc_set_preference('ama-chosen-page', 'homepage', 'automatic_modal_advertising');
        osc_set_preference('ama-user-logged-alert', 'automatic_modal_advertising');
        osc_set_preference('ama-user-logged', 'automatic_modal_advertising');
        osc_reset_preferences();
    }
}
if (!function_exists('automatic_modal_advertising_call_after_uninstall')) {
    function automatic_modal_advertising_call_after_uninstall() {
        osc_delete_preference('automatic_modal_advertising_version', 'automatic_modal_advertising');
        osc_delete_preference('ama-alert-form-box', 'automatic_modal_advertising');
        osc_delete_preference('ama-banner-image-box', 'automatic_modal_advertising');
        osc_delete_preference('ama-embedded-box', 'automatic_modal_advertising');
        osc_delete_preference('ama-embedded-code', 'automatic_modal_advertising');
        osc_delete_preference('ama-custom-css', 'automatic_modal_advertising');
        osc_delete_preference('ama-ipage-alert-form', 'automatic_modal_advertising');
        osc_delete_preference('ama-clickit-alert-form', 'automatic_modal_advertising');
        osc_delete_preference('ama-banner-img', 'automatic_modal_advertising');
        osc_delete_preference('ama-href-banner-img', 'automatic_modal_advertising');
        osc_delete_preference('ama-image-banner-blank', 'automatic_modal_advertising');
        osc_delete_preference('ama-clickit-banner-image', 'automatic_modal_advertising');
        osc_delete_preference('ama-clickit-embedded', 'automatic_modal_advertising');
        osc_delete_preference('ama-chosen-page', 'automatic_modal_advertising');
        osc_delete_preference('ama-user-logged-alert', 'automatic_modal_advertising');
        osc_delete_preference('ama-user-logged', 'automatic_modal_advertising');
    }
}
if( osc_is_admin_user_logged_in() ) {
	switch( Params::getParam('automatic_modal_advertising_specific_zone') ) {
    case('settings'):
        osc_set_preference('ama-alert-form-box', Params::getParam('ama-alert-form-box'), 'automatic_modal_advertising');
        osc_set_preference('ama-banner-image-box', Params::getParam('ama-banner-image-box'), 'automatic_modal_advertising');
        osc_set_preference('ama-embedded-box', Params::getParam('ama-embedded-box'), 'automatic_modal_advertising');
        osc_set_preference('ama-custom-css', Params::getParam('ama-custom-css'), 'automatic_modal_advertising');
        osc_set_preference('ama-ipage-alert-form', Params::getParam('ama-ipage-alert-form'), 'automatic_modal_advertising');
        osc_set_preference('ama-clickit-alert-form', Params::getParam('ama-clickit-alert-form'), 'automatic_modal_advertising');
        osc_set_preference('ama-banner-img', trim(Params::getParam('ama-banner-img', false, false, false)), 'automatic_modal_advertising');
        osc_set_preference('ama-href-banner-img', trim(Params::getParam('ama-href-banner-img', false, false, false)), 'automatic_modal_advertising');
        osc_set_preference('ama-image-banner-blank', Params::getParam('ama-image-banner-blank'), 'automatic_modal_advertising');
        osc_set_preference('ama-embedded-code', trim(Params::getParam('ama-embedded-code', false, false, false)), 'automatic_modal_advertising');
        osc_set_preference('ama-clickit-banner-image', Params::getParam('ama-clickit-banner-image'), 'automatic_modal_advertising');
        osc_set_preference('ama-clickit-embedded', Params::getParam('ama-clickit-embedded'), 'automatic_modal_advertising');
        osc_set_preference('ama-chosen-page', Params::getParam('ama-chosen-page'), 'automatic_modal_advertising');
        osc_set_preference('ama-user-logged-alert', Params::getParam('ama-user-logged-alert'), 'automatic_modal_advertising');
        osc_set_preference('ama-user-logged', Params::getParam('ama-user-logged'), 'automatic_modal_advertising');
        osc_add_flash_ok_message(__('Configuration successfully updated', 'automatic_modal_advertising'), 'admin');
        header('Location: ' . osc_admin_render_plugin_url(osc_plugin_folder(__FILE__) . '/admin/settings.php')); exit;
        break;
	}	
}
if( !function_exists('ama_option_custom_css') ){
    function ama_option_custom_css(){
        return osc_get_preference('ama-custom-css','automatic_modal_advertising');
    }
}
if( !function_exists('ama_alert_form_box') ){
    function ama_alert_form_box(){
        return osc_get_preference('ama-alert-form-box','automatic_modal_advertising');
    }
}
if( !function_exists('ama_ipage_alert_form') ){
    function ama_ipage_alert_form(){
        return osc_get_preference('ama-ipage-alert-form','automatic_modal_advertising');
    }
}
if( !function_exists('ama_chosen_page') ){
    function ama_chosen_page(){
        return osc_get_preference('ama-chosen-page','automatic_modal_advertising');
    }
}
if( !function_exists('ama_image_banner_blank') ){
    function ama_image_banner_blank(){
        return osc_get_preference('ama-image-banner-blank','automatic_modal_advertising');
    }
}
if( !function_exists('ama_user_logged_alert') ){
    function ama_user_logged_alert(){
        return osc_get_preference('ama-user-logged-alert','automatic_modal_advertising');
    }
}
if( !function_exists('ama_user_logged') ){
    function ama_user_logged(){
        return osc_get_preference('ama-user-logged','automatic_modal_advertising');
    }
}
/* start front end content*/
if(ama_alert_form_box()==1 && ama_user_logged() == 1 && !osc_is_web_user_logged_in() or ama_alert_form_box()==1 && ama_user_logged() != 1){
    function ama_alert_form(){
        require_once( AMA_PATH . 'modal/subscribe.php' );
    }
    osc_add_hook('search_conditions', 'ama_alert_form');
}
/* Modal window mode: URL to image */
if( !function_exists('ama_banner_image_box') ){
    function ama_banner_image_box(){
        return osc_get_preference('ama-banner-image-box','automatic_modal_advertising');
    }
}
if(ama_banner_image_box()==1 && ama_user_logged() == 1 && !osc_is_web_user_logged_in() or ama_banner_image_box()==1 && ama_user_logged() != 1){
    function ama_banner_image(){
        if(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'home' && osc_is_home_page()){
            require_once( AMA_PATH . 'modal/banner.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'profile' && osc_is_public_profile()){
            require_once( AMA_PATH . 'modal/banner.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'publish' && osc_is_publish_page()){
            require_once( AMA_PATH . 'modal/banner.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'edit' && osc_is_edit_page()){
            require_once( AMA_PATH . 'modal/banner.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'item' && osc_is_ad_page()){
            require_once( AMA_PATH . 'modal/banner.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'search' && osc_is_search_page()){
            require_once( AMA_PATH . 'modal/banner.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'contact' && osc_is_contact_page()){
            require_once( AMA_PATH . 'modal/banner.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == '404' && osc_is_404()){
            require_once( AMA_PATH . 'modal/banner.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'dashboard-user' && osc_is_user_dashboard()){
            require_once( AMA_PATH . 'modal/banner.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'user-items' && osc_is_list_items()){
            require_once( AMA_PATH . 'modal/banner.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'alerts' && osc_is_list_alerts()){
            require_once( AMA_PATH . 'modal/banner.php' );
        }

    }
    osc_add_hook('footer', 'ama_banner_image');
}
/* Modal window mode: embedded code*/
if( !function_exists('ama_embedded_box') ){
    function ama_embedded_box(){
        return osc_get_preference('ama-embedded-box','automatic_modal_advertising');
    }
}
if(ama_embedded_box()==1 && ama_user_logged() == 1 && !osc_is_web_user_logged_in() or ama_embedded_box()==1 && ama_user_logged() != 1){
    function ama_embedded(){
        if(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'home' && osc_is_home_page()){
            require_once( AMA_PATH . 'modal/embedded.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'profile' && osc_is_public_profile()){
            require_once( AMA_PATH . 'modal/embedded.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'publish' && osc_is_publish_page()){
            require_once( AMA_PATH . 'modal/embedded.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'edit' && osc_is_edit_page()){
            require_once( AMA_PATH . 'modal/embedded.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'item' && osc_is_ad_page()){
            require_once( AMA_PATH . 'modal/embedded.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'alerts' && osc_is_list_alerts()){
            require_once( AMA_PATH . 'modal/embedded.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'search' && osc_is_search_page()){
            require_once( AMA_PATH . 'modal/embedded.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'contact' && osc_is_contact_page()){
            require_once( AMA_PATH . 'modal/embedded.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == '404' && osc_is_404()){
            require_once( AMA_PATH . 'modal/embedded.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'dashboard-user' && osc_is_user_dashboard()){
            require_once( AMA_PATH . 'modal/embedded.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'user-items' && osc_is_list_items()){
            require_once( AMA_PATH . 'modal/embedded.php' );
        }elseif(osc_get_preference('ama-chosen-page','automatic_modal_advertising') == 'alerts' && osc_is_list_alerts()){
            require_once( AMA_PATH . 'modal/embedded.php' );
        }
    }
    osc_add_hook('footer', 'ama_embedded');
}
/* end front end content*/
function automatic_modal_advertising_admin_menu() {
    if(osc_version()<320) {
        echo '<h3><a href="#">automatic_modal_advertising</a></h3>
              <ul>
                  <li><a href="' . osc_admin_render_plugin_url(osc_plugin_folder(__FILE__) . '/admin/settings.php') . '">&raquo; ' . __('Settings', 'automatic_modal_advertising') . '</a></li>
                  <li><a href="' . osc_admin_render_plugin_url(osc_plugin_folder(__FILE__) . '/admin/help.php') . '">&raquo; ' . __('Info', 'automatic_modal_advertising') . '</a></li>
              </ul>';
    } else {
        osc_add_admin_submenu_divider('plugins', 'Automatic modal advertising', 'automatic_modal_advertising_divider', 'administrator');
        osc_add_admin_submenu_page('plugins', __('Settings', 'automatic_modal_advertising'), osc_admin_render_plugin_url(osc_plugin_folder(__FILE__) . '/admin/settings.php'), 'automatic_modal_advertising_settings', 'administrator');
        osc_add_admin_submenu_page('plugins', __('Info', 'automatic_modal_advertising'), osc_admin_render_plugin_url(osc_plugin_folder(__FILE__) . '/admin/help.php'), 'automatic_modal_advertising_help', 'administrator');
    }
}
function automatic_modal_advertising_settings() {
    osc_admin_render_plugin(osc_plugin_path(dirname(__FILE__)) . '/admin/settings.php');
}
function automatic_modal_advertising_help() {
    osc_admin_render_plugin(osc_plugin_path(dirname(__FILE__)) . '/admin/help.php');
}
/* Admin menu */
if(osc_version()<320) {
    osc_add_hook('admin_menu', 'automatic_modal_advertising_admin_menu');
} else {
    osc_add_hook('admin_menu_init', 'automatic_modal_advertising_admin_menu');
}
/* create preferences when the plugin is installed */
osc_register_plugin(osc_plugin_path(__FILE__), 'automatic_modal_advertising_call_after_install');
/* load style */
//osc_add_hook('init', 'automatic_modal_advertising_load_style');
/* delete preferences when the plugin is uninstalled */
osc_add_hook(osc_plugin_path(__FILE__) . '_uninstall', 'automatic_modal_advertising_call_after_uninstall');
/* file end: ./automatic_modal_advertising/index.php */