<?php
/*
Plugin Name: Hfield
Plugin URI:
Description: Hidden field for blocking Bots
Version: 1.5
Author: SmaRTeY&osclass.pro
Author URI: https://osclass.pro
Short Name: hfield
Plugin update URI: 
*/

//Add hook to UserActions without conditions:
osc_add_hook('before_user_register', 'hfield_check');		// - When new user registers
osc_add_hook('pre_item_add', 'hfield_check');				// - When Item is published
osc_add_hook('pre_item_contact_post', 'hfield_check');		// - When user contacts seller on Item page
osc_add_hook('pre_item_send_friend_post', 'hfield_check');	// - When user sends Item to Friend
osc_add_hook('init', 'hfield_contact_check');				// - When user contacts Admin (Init hook is used and we need extra check)

function hfield_contact_check() {
    //Init is generic hook so we do deep check on contact post using the 'action' parameter
	if(Params::getParam('page')=='contact' && Params::getParam('action')=='contact_post'){
        hfield_check(array());
    }
}

//Let's see if a BOT got snagged in your HoneyPot :)
//We have no use for Item parameter but it is returned by one or more hooks so we leave it in
function hfield_check($item='') {
    $input = osc_get_preference('HoneyPot', 'hfield');
	$log = osc_get_preference('Logging', 'hfield');
	$log_human = osc_get_preference('LogHuman', 'hfield');
	if(Params::getParam($input)!='') {
		$demo = osc_get_preference('DemoMode', 'hfield');
		//Underneith error message can be used to test the plugin after you have modified your theme pages
		if($demo==1) {
			$url = osc_base_url();
			osc_add_flash_error_message("hfield: Hey you nasty bot, you fell into my HoneyPot... gnagnagna.");
		} else {
			if($log==1) {
				$Page = Params::getParam('page');
				$Action = Params::getParam('action');
				//Save bot visit in osclass log table
				Log::newInstance()->insertLog('hfield', $Action, 0, $Page, 'visiting bot', 0);
			}
			//Set the URL_Redirect to success page, we love to fool the bot...
			$url = osc_base_url() . 'oc-content/plugins/hfield/success.php';
		}
		osc_redirect_to($url);
	} else {
		if($log_human==1) {
			//Save human submit in osclass log table (could be spammer)			
			$Page = Params::getParam('page');
			$Action = Params::getParam('action');
			Log::newInstance()->insertLog('hfield', $Action, 0, $Page, 'human form submit', 0);
		}
	}
}

//This is the function people have to use in their themes, place before the submit button
//A check is done on the location before adding the HoneyPot input field
function MyHoneyPot() {
    if((Params::getParam('page')=='item' && Params::getParam('action') == 'item_add') ||   // new listing
        Params::getParam('page')=='register' && Params::getParam('action')=='register' ||  // user registration
        Params::getParam('page')=='contact' ||		// webmaster contact
        Params::getParam('page')=='item'  ||		// item contact
        Params::getParam('page')=='send_friend' ||	// send friend
        Params::getParam('page')=='user'  			// user public profile	(not Bender theme)
	) {
		$fieldname = osc_get_preference('HoneyPot', 'hfield');
		$demo = osc_get_preference('DemoMode', 'hfield');
		//Let's add our honeypot pitfall for those nasty bots :)
		//HoneyPot input is default using the Bender style from user_register.php
		if($demo==0) {
            echo '<label for="'.$fieldname.'" class="hp_input">Required</label><input class="hp_input" id="'.$fieldname.'" type="text" name="'.$fieldname.'" value="" />'. PHP_EOL ;
		} else {
			echo '<label for="'.$fieldname.'" class="hp_input">Required</label><input class="hp_input" name="'.$fieldname.'" id="'.$fieldname.'" value="demo_bot" />'. PHP_EOL ;
		}
	}
}

//Create Admin menu
osc_add_hook('admin_header','hfield_admin_menu');
function hfield_admin_menu() {
    osc_add_admin_submenu_page(
        'plugins',
        'Hfield',
        osc_admin_render_plugin_url(osc_plugin_folder(__FILE__)."admin.php"),
        'h
		Hfield',
        'moderator'
    );
}

//Work in style!
osc_add_hook('header', 'hp_style');
function hp_style() {
	//We work in style, the css file is used to hide the style display:none from bots
	osc_enqueue_style('HoneyPot_Style', osc_base_url() . 'oc-content/plugins/hfield/css/style.css' );
}

//We set default settings at install
osc_register_plugin(osc_plugin_path(__FILE__), 'hfield_install');
function hfield_install() {
	osc_set_preference('HoneyPot', 'Lastname', 'hfield', 'STRING');
	osc_set_preference('DemoMode', 0, 'hfield', 'BOOLEAN');
	osc_set_preference('Logging', 1, 'hfield', 'BOOLEAN');
	osc_set_preference('LogHuman', 0, 'hfield', 'BOOLEAN');
}

//We remove the settings if plugin gets uninstalled
osc_add_hook(osc_plugin_path(__FILE__)."_uninstall", 'hfield_uninstall');
function hfield_uninstall() {
    osc_delete_preference('HoneyPot', 'hfield');
	osc_delete_preference('DemoMode', 'hfield');
	osc_delete_preference('Logging', 'hfield');
	osc_delete_preference('LogHuman', 'hfield');
}
?>