<?php
if (!defined('OC_ADMIN') || OC_ADMIN!==true) exit('Access is not allowed.');

//Check if form is posted and save settings
if(Params::getParam('plugin_action')=='post_form') {
    $fieldname	= Params::getParam('HoneyPot');
	$demo = Params::getParam('DemoMode');
	$log = Params::getParam('Logging');
	$log_human = Params::getParam('LogHuman');
    osc_set_preference('HoneyPot', $fieldname, 'hfield', 'STRING');
	osc_set_preference('DemoMode', $demo==1?1:0, 'hfield', 'BOOLEAN');
	osc_set_preference('Logging', $log, 'hfield', 'BOOLEAN');
	osc_set_preference('LogHuman', $log_human, 'hfield', 'BOOLEAN');
    osc_reset_preferences();
    osc_add_flash_ok_message(__('hfield settings saved', 'hfield'), 'admin');
    osc_show_flash_message('admin');
} else {
	$fieldname = osc_get_preference('HoneyPot', 'hfield');
	$demo = osc_get_preference('DemoMode', 'hfield');
	$log = osc_get_preference('Logging', 'hfield');
	$log_human = osc_get_preference('LogHuman', 'hfield');
}
?>

<div style="padding: 20px;">
    <h2 class="render-title"><?php _e('hfield Settings', 'hfield'); ?></h2>
    <form name="hfield" action="<?php echo osc_admin_base_url(true);?>" method="post" enctype="multipart/form-data" >
        <input type="hidden" name="page" value="plugins" />
        <input type="hidden" name="action" value="renderplugin" />
        <input type="hidden" name="file" value="<?php echo osc_plugin_folder(__FILE__);?>admin.php" />
        <input type="hidden" name="plugin_action" value="post_form" />
        <fieldset>
            <div class="form-horizontal">
                <div class="form-row">
                    <div class="form-label" style="padding:0; width:250px;"><?php _e('HoneyPot, name of the input field', 'hfield'); ?></div>
                    <div class="form-controls">
						<input type="text" class="xlarge" style="margin-top:-5px; margin-left:10px;" name="HoneyPot" value="<?php echo $fieldname; ?>">
                    </div>
                </div>
				<div class="form-row">
                    <div class="form-label" style="padding:0; width:250px;"><?php _e('Set DemoMode for testing purpose', 'hfield'); ?></div>
                    <div class="form-controls">
						<input type="checkbox" <?php echo ($demo ? 'checked="true"' : ''); ?> class="xlarge" style="margin-left:10px;" name="DemoMode" value="1" />
                    </div>
                </div>
				<div class="form-row">
                    <div class="form-label" style="padding:0; width:250px;"><?php _e('Enable HoneyPot Logging', 'hfield'); ?></div>
                    <div class="form-controls">
						<input type="checkbox" <?php echo ($log ? 'checked="true"' : ''); ?> class="xlarge" style="margin-left:10px;" name="Logging" value="1" />
                    </div>
                </div>
				<div class="form-row">
                    <div class="form-label" style="padding:0; width:250px;"><?php _e('Enable Human Logging', 'hfield'); ?></div>
                    <div class="form-controls">
						<input type="checkbox" <?php echo ($log_human ? 'checked="true"' : ''); ?> class="xlarge" style="margin-left:10px;" name="LogHuman" value="1" />
                    </div>
                </div>
				<div class="clear"></div>				
				<div class="form-actions">
                    <button type="submit"><?php _e('Save', 'hfield'); ?></button>
                </div>
            </div>
        </fieldset>
    </form>
</div>

<div style="padding: 20px;">
    <h2 class="render-title"><?php _e('How it works', 'hfield'); ?></h2>
	<p><?php _e('Hfield Plugin adds an extra HIDDEN label & input field in your form', 'hfield'); ?></p>
	<p><?php _e('Regular users will NOT see this field, crawler/bots will almost 100% certain fill the hidden input field exposing their existence', 'hfield'); ?></p>
	<br>
    <p><?php _e('With default hfield setting in this page the plugin is setup for "Production Mode"', 'hfield'); ?></p>
    <p><?php _e('The HoneyPot field has a default name Lastname, Logging is default turned ON and Demo Mode is turned OFF, Demo Mode can be enabled to Test the plugin', 'hfield'); ?></p>
	<p><?php _e('If you need a different name for the HoneyPot (ie. other language) just change it name but make sure it is NOT left *empty* and use alphanumeric characters without spaces!', 'hfield'); ?></p>
	<br>
	<h2 class="render-title"><?php _e('Demo Mode', 'hfield'); ?></h2>
	<p><?php _e('If Demo Mode is turned on you can test the page in which you added the code mentioned below by simply filling in the fields and press submit', 'hfield'); ?></p>
	<p><?php _e('After pressing Submit the Demo Mode will redirect you to your Home Page and show a Flash Message confirming it is working', 'hfield'); ?></p>
	<br>
	<h2 class="render-title"><?php _e('Logging Enabled', 'hfield'); ?></h2>
	<p><?php _e('If HoneyPot Logging is enabled all form submits done by crawlers/bots are logged (Date/Time, Plugin name, IP address, Page & Action) in Osclass log table', 'hfield'); ?></p>
	<p><?php _e('If Human Logging is enabled all form submits done via form submit are logged (Date/Time, Plugin name, IP address, Page & Action) in Osclass log table', 'hfield'); ?></p>
	<p><?php _e('To see the logfile you will have to use "phpMyAdmin" and view the table with the name "oc_t_log" (or other db_prefix if this was changed during Osclass install)', 'hfield'); ?></p>
	<br>
    <p><?php _e('To add a HoneyPot to your page(s), paste the following lines of code before the Submit Button:', 'hfield'); ?></p>
    <br>
    <pre>
		<?php echo htmlspecialchars("<?php", ENT_QUOTES); ?> if( function_exists( "MyHoneyPot" )) { <?php echo htmlspecialchars("?>", ENT_QUOTES); ?>
		<?php echo '<div class="controls">'; ?>
			<?php echo htmlspecialchars("<?php", ENT_QUOTES); ?> MyHoneyPot(); <?php echo htmlspecialchars("?>", ENT_QUOTES); ?>
		<?php echo '</div>'; ?>
		<?php echo htmlspecialchars("<?php", ENT_QUOTES); ?> } <?php echo htmlspecialchars("?>", ENT_QUOTES); ?>
    </pre>
	<br/>
    <h3><?php _e('Theme pages (Bender) to add the code mentioned above.', 'hfield'); ?></h3>
    <ul style="line-height: 30px;">
        <li>- <?php _e('New listing page', 'hfield'); ?>						(oc-content/bender/item-post.php)</li>
        <li>- <?php _e('User registration page', 'hfield'); ?>			(oc-content/bender/user-register.php)</li>
        <li>- <?php _e('Web contact page', 'hfield'); ?>						(oc-content/bender/contact.php)</li>
        <li>- <?php _e('Contact listing page', 'hfield'); ?>					(oc-content/bender/item-sidebar.php)</li>
        <li>- <?php _e('Send to a friend listing page', 'hfield'); ?>		(oc-content/bender/item-send-friend.php)</li>
        <li><b>- <?php _e('Soon Public Profile contact page if your theme supports it', 'hfield'); ?></b></li>
    </ul>
</div>