<?php

/*
  Plugin Name: Terms
  Plugin URI: http://osclass.pro/
  Description: Show a checkbox with therms on published page.
  Version: 1.0.5
  Author: osclass
  Author URI: http://osclass.pro/

 */

define('TERMS', '105');

function terms_install() {
    osc_set_preference('include', '1', 'terms');
    osc_set_preference('version', TERMS, 'terms');
}

function terms_uninstall() {
    
}

//update version
if (OC_ADMIN) {
    if (TERMS > osc_get_preference('version', 'terms')) {
        osc_set_preference('version', TERMS, 'terms');
    }
}

//auto include
function terms_include() {
    $value_sesion = '';
    if (Session::newInstance()->_getForm('terms') != '') {
        $value_sesion = Session::newInstance()->_getForm('terms');
    }
    ?>
    <div class="row">
        <label>&nbsp;</label>
        <input style="width:30px !important;" type="checkbox" name="terms_box" id="terms_box" <?php
        if ($value_sesion != '') {
            echo 'checked="yes"';
        }
        ?> value="1"/>
        <span style="margin-left:5px;"><?php printf(__('I agree with these <a target="_blank" href="%s">terms and conditions</a>', 'terms'), osc_get_preference('terms_page', 'terms')); ?></span>
    </div>
    <?php
}

if (osc_get_preference('include', 'terms') == '1') {
    osc_add_hook('item_form', 'terms_include');
    osc_add_hook('item_edit', 'terms_include');
	osc_add_hook('user_register_form', 'terms_include');
}
if (osc_get_preference('include', 'terms') == '0') {

    //manual include
    function terms_manual_include() {
        $value_sesion = '';
        if (Session::newInstance()->_getForm('terms') != '') {
            $value_sesion = Session::newInstance()->_getForm('terms');
        }
        ?>
        <div class="row">
            <label></label>
            <input type="checkbox" name="terms_box" id="terms_box" <?php
            if ($value_sesion != '') {
                echo 'checked="yes"';
            }
            ?> value="1"/>
            <span style="margin-left:5px;"><?php printf(__('I agree with these <a target="_blank" href="%s">terms and conditions</a>', 'terms'), osc_get_preference('terms_page', 'terms')); ?></span>
        </div>
        <?php
    }

}

function terms_pre_post() {
    $terms = Params::getParam('terms_box');
    if (empty($terms)) {
        osc_add_flash_error_message(__('Please read and accept the terms and conditions.', 'terms'));
        $redirect_url = osc_item_post_url();
        osc_redirect_to($redirect_url);
    }
}

osc_add_hook('pre_item_add', 'terms_pre_post');

function terms_pre_edit() {
    $terms = Params::getParam('terms_box');
    if (empty($terms)) {
        osc_add_flash_error_message(__('Please read and accept the terms and conditions.', 'terms'));
        $redirect_url = osc_item_edit_url();
        osc_redirect_to($redirect_url);
    }
}

function terms_before_register() {
	$terms = Params::getParam('terms_box');
    if (empty($terms)) {
            osc_add_flash_error_message( __('You must agree Terms and Conditions in order to register.', 'terms')) ;
            $redirect_url = osc_register_account_url();
            osc_redirect_to($redirect_url);
        }
    }
osc_add_hook('before_user_register', 'terms_before_register');

if (!OC_ADMIN) {
    osc_add_hook('pre_item_edit', 'terms_pre_edit');
}

function terms_keep_data_post() {
    Session::newInstance()->_setForm('terms', Params::getParam("terms_box"));
    Session::newInstance()->_keepForm('terms');
}

osc_add_hook('pre_item_post', 'terms_keep_data_post');

function terms_settings() {
    switch (Params::getParam('action_specific')) {
        case('terms_settings'):
            $include = Params::getParam('include');
            osc_set_preference('include', ($include ? '1' : '0'), 'terms');
            osc_set_preference('terms_page', trim(Params::getParam('terms_page', false, false, false)), 'terms');
            osc_add_flash_ok_message(__('Plugin settings updated correctly', 'terms'), 'admin');
            osc_redirect_to(osc_admin_render_plugin_url('terms/settings.php'));
            break;
    }
}

osc_add_hook('init_admin', 'terms_settings');

function terms_admin() {
    osc_admin_render_plugin('terms/settings.php');
}

osc_add_hook(osc_plugin_path(__FILE__) . "_configure", 'terms_admin');

function terms_admin_menu() {
    osc_admin_menu_plugins(__('Terms Settings', 'firs_one'), osc_admin_render_plugin_url('terms/settings.php'), 'terms_submenu');
}

osc_add_hook('admin_menu_init', 'terms_admin_menu');



osc_register_plugin(osc_plugin_path(__FILE__), 'terms_install');
osc_add_hook(osc_plugin_path(__FILE__) . "_uninstall", 'terms_uninstall');
